include <BOSL2/std.scad>
use <fonts/Yomogi-Regular.ttf>

plane_dimensions = [80,20]; //mm
inner_cutout_dimensions = [70,5]; //mm

plane_thickness = 3; //mm
hinge_thickness = 2.5; //mm
hinge_width = 2; //mm
handle_thickness = 3; //mm
handle_length = 20; //mm
handle_angle = 30; //°

clip_ending_dimensions = [1,1]; //mm

handle_text=["御","嶽"];
handle_text_size = 12.5;
handle_text_depth = 1.5;
handle_text_offset = [1.25,3.75];

resolution = 200;


module handle(mirror_handle=false){
translate([hinge_thickness,-hinge_width/2-plane_thickness,0])
rotate([0,0,handle_angle]) translate([-handle_length+0,0,0]) difference(){cuboid([handle_length,handle_thickness,plane_dimensions.y],anchor=BOTTOM+LEFT+FRONT,$fn=resolution);
    if (mirror_handle){
        translate([handle_text_offset.x,0,handle_text_offset.y]) rotate([90,0,0]) mirror([1,0,0]) translate([0,0,-handle_text_depth]) linear_extrude(handle_text_depth) text(handle_text.x,size=handle_text_size,font="Yomogi",halign="right",$fn=resolution);
        } else {
    translate([handle_text_offset.x,0,handle_text_offset.y]) rotate([90,0,0]) translate([0,0,-handle_text_depth]) linear_extrude(handle_text_depth) text(handle_text.y,size=handle_text_size,font="Yomogi",$fn=resolution);
        }
}
}

union(){
translate([0,-hinge_width/2-plane_thickness,0])
difference(){
cuboid([plane_dimensions.x,hinge_width+plane_thickness*2,plane_dimensions.y],anchor=BOTTOM+LEFT+FRONT,$fn=resolution);
translate([hinge_thickness,plane_thickness,0]) cuboid([plane_dimensions.x-hinge_thickness,hinge_width,plane_dimensions.y],anchor=BOTTOM+LEFT+FRONT,$fn=resolution);
translate([plane_dimensions.x/2-inner_cutout_dimensions.x/2,0,plane_dimensions.y/2-inner_cutout_dimensions.y/2]) cuboid([inner_cutout_dimensions.x,hinge_width+plane_thickness*2,inner_cutout_dimensions.y],anchor=BOTTOM+LEFT+FRONT,$fn=resolution);
}
handle();
mirror([0,1,0])handle(true);
translate([plane_dimensions.x-clip_ending_dimensions.x,-hinge_width/2,0]) cuboid([clip_ending_dimensions.x,clip_ending_dimensions.y,plane_dimensions.y],anchor=BOTTOM+LEFT+FRONT,$fn=resolution);
}